# adventist.corporate Theme for netAdventist

## Installation

This theme can be installed the same way as any other theme. Just download the
theme package and upload that through the “Theme and Templates” admin
interface.

## Required Extensions

This theme requires that the following extensions be installed and activated
before the theme is applied to a site: `adventistid` and `slideshow`. The theme
has these requirements declared in its about.yml so netAdventist core will do
its best to find and activate these extensions at the time of theme
activation. If it cannot, it will abort theme activation and let the user know
which extensions are missing or failed activation.

## Preloaded Widgets

As part of the Required Extensions, we are pre-loading some widgets into the
main theme layouts. These are defined alongside the layouts in `layouts.yml`.
For the home page, we pre-load the `slideshow` widget into our `#hero_unit` widget
container and we pre-load the 2 `adventistid` widgets into the `callout_large` and
`callout_small` widget containers. These are pre-placed and pre-configured
widgets within those containers. They can be overridden or even removed by the
user. If the user already has any widgets at all, we assume they’ve already
got things set up how they’d want and we just ignore the pre-loaded widgets.
Pre-loaded widgets are really only useful for brand new netAdventist sites.

## How this theme works in conjunction with [ALPS](https://alps.adventist.io)

This theme is meant to be an extension of the ALPS framework for the
netAdventist platform. To be able to include the necessary overrides that are
necessary for netAdventist, the ALPS repo is included as a submodule.

### Theme development

Aside from normal theme development (editing `.liquid` and `.yml` files). There
are some special ways the styles for this theme work.

- Clone theme and alps git submodule. [How to clone a repo with submodules](https://stackoverflow.com/a/4438292)
- `cd` into the `alps` directory and follow the instructions in the `/alps/Readme.md` file for getting the custom `grunt` build working.
- Make any style changes necessary in the `netA_overrides` folder and let `grunt` automatically build the ALPS assets and push them into the themes `public/assets` folder.
- **DO NOT** make any changes in the `alps/alps` folder as this will cause a lot of grief if/when the `alps` submodule is updated. Keep all changes in the `alps/netA_overrides` directory.

## How the customizable options work

This theme utilizes new customization options available for themes.
The `about.yml` file is where these theme options are specified.

You can use these options to apply different CSS classes to the `body` tag of
your netAdventist site. Then based on the structure of your CSS you can have
different visual styles depending on which `body` class is selected.

```css
body.primary-1 {
  background: #000;
  color: #fff;
}
body.primary-2 {
  background: #fff;
  color: #000;
}
```

Users will be able to select any of the options that you specify in the
`about.yml` from the “Themes and Templates” section of the Admin.

## How to configure the `about.yml` file

There are three customizable fields that can be specified in the `about.yml`.

```yml
primary_body_classes
secondary_body_classes
background_body_classes
```

In the following example, `primary-1` is the actual text that will be applied
as a class to the `body` tag. `4b207f` is the hex color code (the `#` is
intentionally left off), that will show in the admin area for the user to click
on.

```yml
primary_body_classes:
  primary-1:
    4b207f
  primary-2:
    5e3929
```

`secondary_body_classes` and `background_body_classes` follow the same pattern.

```yml
secondary_body_classes:
  secondary-1:
    4d7549
  secondary-2:
    ffa92d
```

```yml
background_body_classes:
  light:
    ffffff
  dark:
    303030
```
